<?php
/* --------------------------------------------------------------
 GooglePlugin.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace GXModules\Gambio\Google\Admin\Plugin;

use Gambio\Admin\Layout\Smarty\LoadLayoutData;
use Gambio\Core\Application\Plugins\AbstractPlugin;

/**
 * Class GooglePlugin
 * @package GXModules\Gambio\Google
 */
class GooglePlugin extends AbstractPlugin
{
    /**
     * @inheritDoc
     */
    public function commandHandlers(): ?array
    {
        return [
            LoadLayoutData::class => [
                GoogleLoadLayoutDataHandler::class
            ]
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function serviceProviders(): ?array
    {
        return [GoogleServiceProvider::class];
    }
}